#!/bin/tcsh
#
# Copyright (C) 2003-2015 Intel Corporation.  All Rights Reserved.
# 
# The source code contained or described herein and all documents
# related to the source code ("Material") are owned by Intel Corporation
# or its suppliers or licensors.  Title to the Material remains with
# Intel Corporation or its suppliers and licensors.  The Material is
# protected by worldwide copyright and trade secret laws and treaty
# provisions.  No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or
# disclosed in any way without Intel's prior express written permission.
# 
# No license under any patent, copyright, trade secret or other
# intellectual property right is granted to or conferred upon you by
# disclosure or delivery of the Materials, either expressly, by
# implication, inducement, estoppel or otherwise.  Any license under
# such intellectual property rights must be express and approved by
# Intel in writing.
#

setenv I_MPI_ROOT I_MPI_SUBSTITUTE_INSTALLDIR

if !($?PATH) then
    setenv PATH ${I_MPI_ROOT}/mic/bin
else
    setenv PATH ${I_MPI_ROOT}/mic/bin:${PATH}
endif

if !($?LD_LIBRARY_PATH) then
    setenv LD_LIBRARY_PATH ${I_MPI_ROOT}/mic/lib:${I_MPI_ROOT}/intel64/lib
else
    setenv LD_LIBRARY_PATH ${I_MPI_ROOT}/mic/lib:${I_MPI_ROOT}/intel64/lib:${LD_LIBRARY_PATH}
endif

if !($?MANPATH) then
    if ( `uname -m` == "k1om" ) then
        setenv MANPATH ${I_MPI_ROOT}/man
    else
        setenv MANPATH ${I_MPI_ROOT}/man:`manpath`
    endif
else
    setenv MANPATH ${I_MPI_ROOT}/man:${MANPATH}
endif

set library_kind
if ( $# > 0 ) then
    set library_kind $1
else if ( $?I_MPI_LIBRARY_KIND ) then
    set library_kind $I_MPI_LIBRARY_KIND
endif

switch ($library_kind)
    case debug:
    case debug_mt:
    case release:
    case release_mt:
        setenv LD_LIBRARY_PATH ${I_MPI_ROOT}/mic/lib/${library_kind}:${I_MPI_ROOT}/intel64/lib/${library_kind}:${LD_LIBRARY_PATH}
        breaksw
    case "":
        breaksw
    case --help:
    case -h:
        echo ""
        echo "Usage: mpivars.sh <i_mpi_library_kind>"
        echo ""
        echo "<i_mpi_library_kind> must be one of the following:"
        echo "      debug           "
        echo "      debug_mt        "
        echo "      release         "
        echo "      release_mt      "
        echo ""
        echo "If the arguments to the sourced script are ignored (consult docs"
        echo "for your shell) the alternative way to specify target is environment"
        echo "variables I_MPI_LIBRARY_KIND to pass"
        echo "<i_mpi_library_kind>  to the script."
        echo ""
        breaksw
endsw
