#!/bin/bash
# Copyright (C) 2002-2014, Intel Corporation. All rights reserved.
#
# The source code, information and material ("Material") contained herein is owned by Intel Corporation
# or its suppliers or licensors, and title to such Material remains with Intel Corporation or its suppliers
# or licensors. The Material contains proprietary information of Intel or its suppliers and licensors.
# The Material is protected by worldwide copyright laws and treaty provisions. No part of the Material may be
# used, copied, reproduced, modified, published, uploaded, posted, transmitted, distributed or disclosed in
# any way without Intel's prior express written permission. No license under any patent, copyright or other
# intellectual property rights in the Material is granted to or conferred upon you, either expressly, by implication,
# inducement, estoppel or otherwise. Any license under such intellectual property rights must be express and approved
# by Intel in writing.
#
# Unless otherwise agreed by Intel in writing, you may not remove or alter this notice or any other notice embedded
# in Materials by Intel or Intel's suppliers or licensors in any way.
#

INSTALL_SCRIPT="$1"

if [ -z "$INSTALL_SCRIPT" ]; then
    echo "Error: Please specify path to product install.sh file"
    exit 1
fi

declare -r TERMINALS=(xterm gnome-terminal urxvt rxvt)

for TERM in ${TERMINALS[@]}; do
    which $TERM 2>/dev/null 1>&2
    if [ $? -eq 0 ]; then
        tmpfile=$(mktemp)

        if [ "$TERM" = "gnome-terminal" ]; then
            $TERM -e "/bin/bash -c \"export skip_uid_check=yes ; $INSTALL_SCRIPT ; echo \$? > $tmpfile\""
        else
            $TERM -e /bin/bash -c "export skip_uid_check=yes ; $INSTALL_SCRIPT ; echo \$? > $tmpfile"
        fi

        status=$(cat $tmpfile 2>/dev/null)

        rm -rf $tmpfile 2>/dev/null 1>&2

        exit $status
    fi
done

exit 1
